package cache

import (
	"fmt"
	"time"

	"github.com/go-redis/redis"
	"github.com/pkg/errors"
	log "github.com/sirupsen/logrus"
)

const expiration = 30 * time.Minute

// Redis contains the Redis connection.
type Redis struct {
	client *redis.Client
}

// NewRedis opens a connection pool to a Redis database.
func NewRedis(host, port string) (*Redis, error) {
	address := fmt.Sprintf("%s:%s", host, port)

	client := redis.NewClient(&redis.Options{
		Addr:       address,
		Password:   "",
		DB:         0,
		MaxRetries: 3,
		PoolSize:   20,
	})

	pong, err := client.Ping().Result()
	if err != nil {
		return nil, errors.Wrap(err, "cache: failed to ping redis")
	}

	log.Infof("cache: redis %s at %s", pong, address)

	return &Redis{
		client: client,
	}, nil
}
