package pushy

import (
	"context"
)

// Pushy interface for Mockery.
type Pushy interface {
	// PublishInvite sends a message to the pushy dispatch sns. The message is then consumed by
	// pushy and send email inviting person to the team.
	PublishInvite(ctx context.Context, teamUserID, teamName, userID string) error
	// PublishInviteDeclined sends a message to the pushy dispatch sns. The message is then consumed by
	// pushy and send email about invite being declined to team user.
	PublishInviteDeclined(ctx context.Context, teamUserID, teamName, userID string) error
	// PublishInviteAccepted sends a message to the pushy dispatch sns. The message is then consumed by
	// pushy and send email about invite being accepted to team user.
	PublishInviteAccepted(ctx context.Context, teamUserID, teamName, userID string) error
}
