package telemetryhook

import (
	"net/http"

	telemetry "code.justin.tv/amzn/TwitchTelemetry"
)

// Handler is an interface for a Telemetry hook
type Handler interface {
	TelemetryMetricsHandler(inner http.Handler) http.Handler
}

// Client is the telemetry client specifically used for the middleware
type Client struct {
	Reporter telemetry.SampleReporter
}

// NoopClient is the telemetry noop client
type NoopClient struct{}

// ReporterWithDimensions is a helper that will add dimensions and return a sampleReporter.
func ReporterWithDimensions(dimensions map[string]string, reporter telemetry.SampleReporter) telemetry.SampleReporter {
	allDims := make(map[string]string, len(reporter.Dimensions)+len(dimensions))
	for k, v := range reporter.Dimensions {
		allDims[k] = v
	}

	for k, v := range dimensions {
		allDims[k] = v
	}

	reporter.Dimensions = allDims

	return reporter
}
