package users

import (
	"code.justin.tv/web/users-service/client"
	"github.com/cep21/circuit"
)

type usersErrorWrapper struct {
	err error
}

var _ circuit.BadRequest = new(usersErrorWrapper)
var _ error = new(usersErrorWrapper)

func wrapUsersError(err error) error {
	if err == nil {
		return nil
	}

	return usersErrorWrapper{err}
}

func (w usersErrorWrapper) BadRequest() bool {
	if e, ok := w.err.(client.Error); ok && e.StatusCode() >= 400 && e.StatusCode() < 500 {
		return true
	}

	return false
}

func (w usersErrorWrapper) Error() string {
	return w.err.Error()
}

func (w usersErrorWrapper) Cause() error {
	return w.err
}
