// +build integration

package db

import (
	"os"

	_ "github.com/lib/pq"
	. "github.com/onsi/ginkgo"
	. "github.com/onsi/gomega"
)

var _ = Describe("DB Client", func() {
	It("Creates a client", func() {
		client, err := NewClient(ClientConfig{
			Host:     os.Getenv("DB_HOST"),
			Port:     os.Getenv("DB_PORT"),
			DBName:   os.Getenv("DB_NAME"),
			User:     os.Getenv("DB_USER"),
			Password: os.Getenv("DB_PASSWORD"),
		})

		Expect(err).NotTo(HaveOccurred())
		Expect(client).NotTo(BeNil())
	})
})
