package db

import (
	"context"

	"github.com/pkg/errors"
)

// CreateFeaturedChannel makes a INSERT query to DB to create a record
// in `team_streams` for a given team ID and user id.
func (c *Client) CreateFeaturedChannel(ctx context.Context, teamID, channelID string) error {
	statement := `
		INSERT INTO team_streams (team_id, user_id, display_order, created_at)
		SELECT $1, $2, COALESCE(MAX(display_order) + 1, 0), CURRENT_TIMESTAMP
		FROM team_streams
		WHERE team_id = $1
		AND NOT EXISTS (
			SELECT *
			FROM team_streams
			WHERE team_id = $1
			AND user_id = $2
		)
	`

	result, err := c.db.ExecContext(ctx, statement, teamID, channelID)
	if err != nil {
		return errors.Wrap(err, "db: failed to insert row into team_streams")
	}

	rowsInserted, err := result.RowsAffected()
	if err != nil || rowsInserted < 1 {
		return ErrNoFeaturedChannelCreated
	}

	return nil
}
