package db

import (
	"context"

	"github.com/pkg/errors"
)

// CreateInvitation makes a INSERT query to DB to create a record
// in `team_invitations` for a given team ID and user id.
func (c *Client) CreateInvitation(ctx context.Context, teamID, channelID string) error {
	statement := `
		INSERT INTO team_invitations (team_id, user_id, created_on)
		SELECT $1, $2, CURRENT_TIMESTAMP
		WHERE NOT EXISTS (
			SELECT *
			FROM team_invitations
			WHERE team_id = $1
			AND user_id = $2
		)
	`

	result, err := c.db.ExecContext(ctx, statement, teamID, channelID)
	if err != nil {
		return errors.Wrap(err, "db: failed to insert row into team_invitations")
	}

	rowsAffected, err := result.RowsAffected()
	if err != nil || rowsAffected < 1 {
		return ErrNoInvitationCreated
	}

	return nil
}
