package db

import (
	"context"

	"github.com/pkg/errors"
	log "github.com/sirupsen/logrus"
)

// DeleteChannelInvitations makes a DELETE query to DB
// to remove all records from the `team_invitations` table,
// given a particular user id.
func (c *Client) DeleteChannelInvitations(ctx context.Context, userID string) error {
	statement := `
		DELETE
		FROM team_invitations
		WHERE user_id = $1
	`

	defer func() {
		if r := recover(); r != nil {
			log.WithError(r.(error)).WithFields(log.Fields{
				"statement": statement,
				"user_id":   userID,
			}).Error("db: failed to close rows")
		}
	}()

	result, err := c.db.ExecContext(ctx, statement, userID)
	if err != nil {
		return errors.Wrap(err, "db: failed to delete row from team_invitations")
	}

	rowsAffected, err := result.RowsAffected()
	if err != nil {
		return errors.Wrap(err, "db: cannot determine if row deleted from team_invitations")
	}

	if rowsAffected < 1 {
		return ErrNoRowFoundForDeletion
	}

	return nil
}
