package db

import (
	"context"
	"database/sql"
	"errors"

	"code.justin.tv/cb/roster/internal/postgres"
	. "github.com/onsi/ginkgo"
	. "github.com/onsi/gomega"
	"gopkg.in/DATA-DOG/go-sqlmock.v1"
)

var _ = Describe("DeleteChannelInvitations", func() {
	var (
		client           *Client
		mock             sqlmock.Sqlmock
		channelID        string
		deleteQueryRegEx string
	)

	BeforeEach(func() {
		var stub *sql.DB
		var err error

		stub, mock, err = sqlmock.New()
		Expect(err).NotTo(HaveOccurred())

		postgresDB := &postgres.DB{
			DB: stub,
		}

		client = &Client{
			db: postgresDB,
			displayPositioner: &displayPositionHelper{
				db: postgresDB,
			},
		}

		channelID = "999999999"
		deleteQueryRegEx = `DELETE FROM team_invitations WHERE user_id = \$1`
	})

	It("fails when fails to query fails", func() {
		mock.ExpectExec(deleteQueryRegEx).
			WithArgs(channelID).
			WillReturnError(errors.New("db: failed to delete row from team_invitations"))

		err := client.DeleteChannelInvitations(context.Background(), channelID)
		Expect(err.Error()).To(ContainSubstring("db: failed to delete row from team_invitations"))

		mockError := mock.ExpectationsWereMet()
		Expect(mockError).NotTo(HaveOccurred())
	})

	It("succeed", func() {
		mock.ExpectExec(deleteQueryRegEx).
			WithArgs(channelID).
			WillReturnResult(sqlmock.NewResult(0, 1))

		err := client.DeleteChannelInvitations(context.Background(), channelID)
		Expect(err).NotTo(HaveOccurred())
	})

})
