package db

import (
	"context"
)

// DeleteFeaturedChannel makes a DELETE command to DB
// to delete the record from the `team_streams` table,
// given a particular team ID and user id.
//
// The display position (`display_order`) of other
// `team_streams` records may be downshifted by one
// to fill the gap.
func (c *Client) DeleteFeaturedChannel(ctx context.Context, teamID, channelID string) error {
	return c.deleteRowWithDisplayOrder(ctx, "team_streams", teamID, channelID)
}
