package db

import (
	"context"

	"github.com/pkg/errors"
)

// DeleteInvitation makes a DELETE command to DB
// to delete the record from the `team_invitations` table,
// given a particular team ID and user id.
func (c *Client) DeleteInvitation(ctx context.Context, teamID, channelID string) error {
	statement := "DELETE FROM team_invitations WHERE team_id = $1 AND user_id = $2"

	result, err := c.db.ExecContext(ctx, statement, teamID, channelID)
	if err != nil {
		return errors.Wrap(err, "db: failed to delete row from team_invitations")
	}

	rowsAffected, err := result.RowsAffected()
	if err != nil || rowsAffected < 1 {
		return ErrNoRowFoundForDeletion
	}

	return nil
}
