package db

import (
	"context"
)

// DeleteMembership makes a DELETE command to DB
// to delete the record from the `team_users` table,
// given a particular team ID and user id.
//
// The display position (`display_order`) of other
// `team_users` records may be downshifted by one
// to fill the gap.
func (c *Client) DeleteMembership(ctx context.Context, teamID, channelID string) error {
	return c.deleteRowWithDisplayOrder(ctx, "team_users", teamID, channelID)
}
