package db

// Table "public.teams"
//
// Column        |            Type             | Collation | Nullable |              Default
// ----------------------+-----------------------------+-----------+----------+-----------------------------------
// id                   | integer                     |           | not null | nextval('teams_id_seq'::regclass)
// name                 | character varying(255)      |           |          |
// display_name         | character varying(255)      |           |          |
// user_id              | integer                     |           |          |
// info                 | text                        |           |          |
// banner_image         | character varying(255)      |           |          |
// created_at           | timestamp without time zone |           |          |
// updated_at           | timestamp without time zone |           |          |
// background_color     | character varying(255)      |           |          |
// background_image     | character varying(255)      |           |          |
// background_no_repeat | boolean                     |           |          |
// team_logo_image      | character varying(255)      |           |          |
// short_name           | character varying(255)      |           |          |
// status               | character varying(255)      |           |          | 'active'::character varying
// focus_info_tab       | boolean                     |           | not null | false
// show_chat_tab        | boolean                     |           |          | false
//
// Indexes:
// "teams_pkey" PRIMARY KEY, btree (id)
// "index_teams_on_name" btree (name)
//
//
//
// Table "public.team_users"
//
// Column     |            Type             |                        Modifiers
// ---------------+-----------------------------+---------------------------------------------------------
// id            | integer                     | not null default nextval('team_users_id_seq'::regclass)
// team_id       | integer                     |
// user_id       | integer                     |
// display_order | integer                     | default 0
// created_at    | timestamp without time zone |
// updated_at    | timestamp without time zone |
// view_revenue  | boolean                     | default false
// view_stats    | boolean                     | default false
//
// Indexes:
// "team_users_pkey" PRIMARY KEY, btree (id)
// "index_team_users_on_team_id" btree (team_id)
// "index_team_users_on_user_id" btree (user_id)
//
//
//
// Table "public.team_invitations"
// Column   |            Type             | Collation | Nullable |                   Default
// ------------+-----------------------------+-----------+----------+----------------------------------------------
// id         | integer                     |           | not null | nextval('team_invitations_id_seq'::regclass)
// team_id    | integer                     |           |          |
// user_id    | integer                     |           |          |
// status     | character varying(255)      |           |          | 'pending'::character varying
// created_on | timestamp without time zone |           |          |
// updated_on | timestamp without time zone |           |          |
// Indexes:
// "team_invitations_pkey" PRIMARY KEY, btree (id)
// "index_team_invitations_on_team_id" btree (team_id)
// "index_team_invitations_on_user_id" btree (user_id)
//
//
//
// Table "public.team_streams"
// Column     |            Type             | Collation | Nullable |                 Default
// ---------------+-----------------------------+-----------+----------+------------------------------------------
// id            | integer                     |           | not null | nextval('team_streams_id_seq'::regclass)
// team_id       | integer                     |           |          |
// user_id       | integer                     |           |          |
// display_order | integer                     |           |          | 0
// created_at    | timestamp without time zone |           |          |
// updated_at    | timestamp without time zone |           |          |
// Indexes:
// "team_streams_pkey" PRIMARY KEY, btree (id)
//
