package db

import (
	"errors"
)

var (
	// ErrNoTeam is returned when querying for one Team record that does not exist.
	ErrNoTeam = errors.New("db: no team found")

	// ErrNoTeamCreated is returned when creating a Team record failed.
	ErrNoTeamCreated = errors.New("db: no team created")

	// ErrNoTeamForUpdate is returned when querying for one Team record that does not exist.
	ErrNoTeamForUpdate = errors.New("db: no team to update")

	// ErrNoTeamDeleted is returned when a DELETE command for one Team record results in no rows affected.
	ErrNoTeamDeleted = errors.New("db: no team deleted")

	// ErrNoInvitation is returned when querying for one Invitation record that does not exist.
	ErrNoInvitation = errors.New("db: no invitation found")

	// ErrNoInvitationCreated is returned when creating an invitation record failed.
	ErrNoInvitationCreated = errors.New("db: no invitation created")

	// ErrNoInvitationDeleted is returned when deleting an invitation record failed.
	ErrNoInvitationDeleted = errors.New("db: invitation was unable to be deleted")

	// ErrNoRowFoundForDeletion is returned when a delete attempt does not find a row to delete.
	ErrNoRowFoundForDeletion = errors.New("db: no row to delete")

	// ErrNoMembership is returned when querying for one Membership record that does not exist.
	ErrNoMembership = errors.New("db: no membership found")

	// ErrNoMembershipForUpdate is returned when querying for one Membership record that does not exist.
	ErrNoMembershipForUpdate = errors.New("db: no membership to update")

	// ErrNoMembershipCreated is returned when creating a membership record failed.
	ErrNoMembershipCreated = errors.New("db: no membership created")

	// ErrNoFeaturedChannel is returned when querying for one Featured Channel record that does not exist.
	ErrNoFeaturedChannel = errors.New("db: no featured channel found")

	// ErrNoFeaturedChannelCreated is returned when creating a featured channel failed.
	ErrNoFeaturedChannelCreated = errors.New("db: no featured channel created")

	// ErrNoFeaturedChannelForUpdate is returned when updating a featured channel does not find
	// a featured channel to update.
	ErrNoFeaturedChannelForUpdate = errors.New("db: no featured channel to update")
)
