package db

import (
	"context"
	"database/sql"

	"github.com/pkg/errors"
)

// GetFeaturedChannel makes a SELECT query to DB
// to find an existing record from the `team_streams` table,
// given a particular team ID and user id.
func (c *Client) GetFeaturedChannel(ctx context.Context, teamID, channelID string) (FeaturedChannel, error) {
	result, err := c.getRow(ctx, "team_streams", teamID, channelID)
	featuredChannel := FeaturedChannel(result)

	switch {
	case err == sql.ErrNoRows:
		return featuredChannel, ErrNoFeaturedChannel
	case err != nil:
		return featuredChannel, errors.Wrap(err, "db: failed to scan team_streams row")
	}

	return featuredChannel, nil
}
