package db

import (
	"context"
)

// GetFeaturedChannels makes a SELECT query from DB
// for a list of records from the `team_streams` table,
// given a particular team ID (`team_streams.team_id`).
func (c *Client) GetFeaturedChannels(ctx context.Context, teamID string) ([]FeaturedChannel, error) {
	results, err := c.getRows(ctx, "team_streams", "display_order", teamID)
	if err != nil {
		return nil, err
	}

	featuredChannels := make([]FeaturedChannel, len(results))
	for idx, result := range results {
		featuredChannels[idx] = FeaturedChannel(result)
	}

	return featuredChannels, nil
}
