package db

import (
	"context"
	"database/sql"

	"github.com/pkg/errors"
)

// GetInvitation makes a SELECT query to DB
// to find an existing record from the `team_invitations` table,
// given a particular team ID and user id.
func (c *Client) GetInvitation(ctx context.Context, teamID, channelID string) (Invitation, error) {
	result, err := c.getRow(ctx, "team_invitations", teamID, channelID)
	invitation := Invitation(result)

	switch {
	case err == sql.ErrNoRows:
		return invitation, ErrNoInvitation
	case err != nil:
		return invitation, errors.Wrap(err, "db: failed to scan team_invitations row")
	}

	return invitation, nil
}
