package db

import (
	"context"
	"database/sql"

	"github.com/pkg/errors"
)

// GetMembership makes a SELECT query to DB
// to find an existing record from the `team_users` table,
// given a particular team ID and user id.
func (c *Client) GetMembership(ctx context.Context, teamID, channelID string) (Membership, error) {
	statement := `
		SELECT team_id, user_id, view_revenue, view_stats
		FROM team_users
		WHERE team_id = $1 AND user_id = $2
		LIMIT 1
	`

	membership := Membership{}
	row := c.db.QueryRowContext(ctx, statement, teamID, channelID)
	err := row.Scan(
		&membership.TeamID,
		&membership.ChannelID,
		&membership.RevenueRevealed,
		&membership.StatsRevealed,
	)

	switch {
	case err == sql.ErrNoRows:
		return membership, ErrNoMembership
	case err != nil:
		return membership, errors.Wrap(err, "db: failed to scan team_users row")
	}

	return membership, nil
}
