package db

import (
	"context"

	"github.com/pkg/errors"
	log "github.com/sirupsen/logrus"
)

// GetTeamByID makes a SELECT query from DB for a record
// from the `teams` table given a particular team ID (`teams.id`).
func (c *Client) GetTeamByID(ctx context.Context, id string) (Team, error) {
	statement := `
		SELECT id, name, display_name, user_id, info, team_logo_image, banner_image, background_image, created_at, updated_at
		FROM teams
		WHERE id = $1
		LIMIT 1
	`

	team := Team{}
	rows, err := c.db.QueryContext(ctx, statement, id)
	if err != nil {
		return team, errors.Wrap(err, "db: failed to query teams")
	}

	if !rows.Next() {
		return team, ErrNoTeam
	}

	defer func() {
		if err = rows.Close(); err != nil {
			log.WithError(err).Error("db: failed to close rows for teams")
		}
	}()

	return teamFromRows(rows)
}
