package db

import (
	"context"
)

// GetTeamInvitations makes a SELECT query from DB
// for a list of records from the `team_invitations` table,
// given a particular team ID (`team_invitations.team_id`).
func (c *Client) GetTeamInvitations(ctx context.Context, teamID string) ([]Invitation, error) {
	results, err := c.getRows(ctx, "team_invitations", "created_on", teamID)
	if err != nil {
		return nil, err
	}

	invitations := make([]Invitation, len(results))
	for idx, result := range results {
		invitations[idx] = Invitation(result)
	}

	return invitations, nil
}
