package db

import (
	"context"

	"github.com/pkg/errors"
)

// GetTeamsCount queries DB for the total count of teams.
func (c *Client) GetTeamsCount(ctx context.Context, filter TeamsFilter) (uint, error) {
	var count uint

	row := c.db.QueryRowContext(ctx, "SELECT COUNT(*) FROM teams WHERE $1 = '' OR name = $1", filter.Name)

	if err := row.Scan(&count); err != nil {
		return 0, errors.Wrap(err, "db: failed to query team count")
	}

	return count, nil
}
