--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET row_security = off;

SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: teams; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE teams (
    id integer NOT NULL,
    name character varying(255),
    display_name character varying(255),
    user_id integer,
    info text,
    banner_image character varying(255),
    created_at timestamp without time zone,
    updated_at timestamp without time zone,
    background_color character varying(255),
    background_image character varying(255),
    background_no_repeat boolean,
    team_logo_image character varying(255),
    short_name character varying(255),
    status character varying(255) DEFAULT 'active'::character varying,
    focus_info_tab boolean DEFAULT false NOT NULL,
    show_chat_tab boolean DEFAULT false
);

--
-- Name: teams_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE teams_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;

--
-- Name: teams_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE teams_id_seq OWNED BY teams.id;


--
-- Name: teams id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY teams ALTER COLUMN id SET DEFAULT nextval('teams_id_seq'::regclass);


--
-- Name: teams teams_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY teams
    ADD CONSTRAINT teams_pkey PRIMARY KEY (id);


--
-- Name: index_teams_on_name; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX index_teams_on_name ON teams USING btree (name);


--
-- Name: team_users; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE team_users (
    id integer NOT NULL,
    team_id integer,
    user_id integer,
    display_order integer DEFAULT 0,
    created_at timestamp without time zone,
    updated_at timestamp without time zone,
    view_revenue boolean DEFAULT false,
    view_stats boolean DEFAULT false
);

--
-- Name: team_users_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE team_users_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;

--
-- Name: team_users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE team_users_id_seq OWNED BY team_users.id;


--
-- Name: team_users id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY team_users ALTER COLUMN id SET DEFAULT nextval('team_users_id_seq'::regclass);


--
-- Name: team_users team_users_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY team_users
    ADD CONSTRAINT team_users_pkey PRIMARY KEY (id);


--
-- Name: index_team_users_on_team_id; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX index_team_users_on_team_id ON team_users USING btree (team_id);


--
-- Name: index_team_users_on_user_id; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX index_team_users_on_user_id ON team_users USING btree (user_id);


--
-- Name: team_invitations; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE team_invitations (
    id integer NOT NULL,
    team_id integer,
    user_id integer,
    status character varying(255) DEFAULT 'pending'::character varying,
    created_on timestamp without time zone,
    updated_on timestamp without time zone
);

--
-- Name: team_invitations_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE team_invitations_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;

--
-- Name: team_invitations_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE team_invitations_id_seq OWNED BY team_invitations.id;


--
-- Name: team_invitations id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY team_invitations ALTER COLUMN id SET DEFAULT nextval('team_invitations_id_seq'::regclass);


--
-- Name: team_invitations team_invitations_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY team_invitations
    ADD CONSTRAINT team_invitations_pkey PRIMARY KEY (id);


--
-- Name: index_team_invitations_on_team_id; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX index_team_invitations_on_team_id ON team_invitations USING btree (team_id);


--
-- Name: index_team_invitations_on_user_id; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX index_team_invitations_on_user_id ON team_invitations USING btree (user_id);


--
-- Name: team_streams; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE team_streams (
    id integer NOT NULL,
    team_id integer,
    user_id integer,
    display_order integer DEFAULT 0,
    created_at timestamp without time zone,
    updated_at timestamp without time zone
);


--
-- Name: team_streams_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE team_streams_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: team_streams_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE team_streams_id_seq OWNED BY team_streams.id;


--
-- Name: team_streams id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY team_streams ALTER COLUMN id SET DEFAULT nextval('team_streams_id_seq'::regclass);


--
-- Name: team_streams team_streams_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY team_streams
    ADD CONSTRAINT team_streams_pkey PRIMARY KEY (id);


--
-- PostgreSQL database dump complete
--
