package db

import (
	"context"

	"github.com/pkg/errors"
)

// SearchTeamsCount queries DB for the total count of teams given the search parameters.
func (c *Client) SearchTeamsCount(ctx context.Context, filter SearchTeamsFilter) (uint, error) {
	statement := `
		SELECT COUNT(*)
		FROM teams
		WHERE name ILIKE '%' || $1 || '%'
	`

	var count uint

	err := c.db.QueryRowContext(ctx, statement, filter.Name).Scan(&count)
	if err != nil {
		return 0, errors.Wrap(err, "db: failed to query count of teams for search")
	}

	return count, nil
}
