package db

import (
	"context"
	"database/sql"
)

// UpdateFeaturedChannelDisplayPosition makes multiple UPDATE commands to DB
// to update the display positions (`display_order`) of a given team's
// `team_streams` rows.
func (c *Client) UpdateFeaturedChannelDisplayPosition(ctx context.Context, teamID string, channelID string, desiredPosition uint) error {
	err := c.displayPositioner.Update(ctx, "team_streams", teamID, channelID, desiredPosition)
	if err == sql.ErrNoRows {
		return ErrNoFeaturedChannelForUpdate
	}
	if err != nil {
		return err
	}

	return nil
}
