package db

import (
	"context"

	"github.com/pkg/errors"
)

// UpdateMembership makes an UPDATE command to DB to change the revenue and stats fields
// of a `team_users` record for a given team ID and user ID.
func (c *Client) UpdateMembership(ctx context.Context, teamID, channelID string, revenueRevealed, statsRevealed bool) error {
	statement := `
		UPDATE team_users
 		SET
			view_revenue = $1,
			view_stats = $2,
			updated_at = CURRENT_TIMESTAMP
		WHERE team_id = $3
		AND user_id = $4
	`

	result, err := c.db.ExecContext(
		ctx,
		statement,
		revenueRevealed,
		statsRevealed,
		teamID,
		channelID,
	)
	if err != nil {
		return errors.Wrap(err, "db: failed to update membership")
	}

	rowsAffected, err := result.RowsAffected()
	if err != nil {
		return errors.Wrap(err, "db: cannot determine if row update from team_users")
	}

	if rowsAffected < 1 {
		return ErrNoMembershipForUpdate
	}

	return nil
}
