package db

import (
	"context"
	"database/sql"
)

// UpdateMembershipDisplayPosition makes multiple UPDATE commands to DB
// to update the display positions (`display_order`) of a given team's
// `team_users` rows.
func (c *Client) UpdateMembershipDisplayPosition(ctx context.Context, teamID string, channelID string, desiredPosition uint) error {
	err := c.displayPositioner.Update(ctx, "team_users", teamID, channelID, desiredPosition)
	if err == sql.ErrNoRows {
		return ErrNoMembershipForUpdate
	}
	if err != nil {
		return err
	}

	return nil
}
