package db

import (
	"context"
	"database/sql"

	"code.justin.tv/cb/roster/internal/db/mocks"
	"code.justin.tv/cb/roster/internal/postgres"
	. "github.com/onsi/ginkgo"
	. "github.com/onsi/gomega"
	"github.com/stretchr/testify/mock"
)

var _ = Describe("UpdateMembershipDisplayPosition", func() {
	var (
		db                     *Client
		teamID                 string
		channelID              string
		desiredDisplayPosition uint
		fakeDisplayPositioner  *mocks.DisplayPositioner
	)

	BeforeEach(func() {
		fakeDisplayPositioner = &mocks.DisplayPositioner{}

		db = &Client{
			db:                &postgres.DB{},
			displayPositioner: fakeDisplayPositioner,
		}

		teamID = "123"
		channelID = "999999999"
		desiredDisplayPosition = 100000
	})

	It("returns ErrNoMembershipForUpdate when channel is not featured by team", func() {
		fakeDisplayPositioner.On("Update", mock.Anything, "team_users", teamID, channelID, desiredDisplayPosition).
			Return(sql.ErrNoRows)

		err := db.UpdateMembershipDisplayPosition(context.Background(), teamID, channelID, desiredDisplayPosition)
		Expect(err).To(Equal(ErrNoMembershipForUpdate))
	})

	It("returns no error when updating featured channel display position succeeds", func() {
		fakeDisplayPositioner.On("Update", mock.Anything, "team_users", teamID, channelID, desiredDisplayPosition).
			Return(nil)
		err := db.UpdateMembershipDisplayPosition(context.Background(), teamID, channelID, desiredDisplayPosition)
		Expect(err).NotTo(HaveOccurred())
	})
})
