package description

import (
	"strings"

	"github.com/lunny/html2md"
	"gopkg.in/russross/blackfriday.v2"
)

// HTMLToMarkdown converts HTML string input into Markdown,
// while sanitizing the input.
func HTMLToMarkdown(html string) string {
	sanitizedHTML := htmlPolicy.Sanitize(html)
	markdown := html2md.Convert(sanitizedHTML)

	return strings.TrimSpace(markdown)
}

// MarkdownToHTML converts Markdown string input into HTML,
// while sanitizing the input.
func MarkdownToHTML(markdown string) string {
	processed := blackfriday.Run([]byte(markdown))
	sanitizedHTML := htmlPolicy.SanitizeBytes(processed)

	return string(sanitizedHTML)
}
