package description

import (
	"github.com/microcosm-cc/bluemonday"
)

var htmlPolicy *bluemonday.Policy

func init() {
	htmlPolicy = bluemonday.UGCPolicy()

	htmlPolicy.RequireParseableURLs(true)
	htmlPolicy.RequireNoFollowOnLinks(true)
	htmlPolicy.AllowURLSchemes("mailto", "http", "https")
	htmlPolicy.AddTargetBlankToFullyQualifiedLinks(true)
}

// MaxLength is the maximum rune count of a description string.
const MaxLength = 10000
