package eventbus

import (
	"context"

	"code.justin.tv/cb/roster/internal/db"
)

// Cache is the interface to a caching service.
type Cache interface {
	ClearChannelMemberships(ctx context.Context, id string) error
	ClearAllTeamMembershipsForTeam(ctx context.Context, id string) error
}

// DBWriter is how the Roster app expects the writing to DB to be.
type DBWriter interface {
	// Gets Team Memberships by Channel ID, returns empty array if no Memberships are found.
	GetChannelMemberships(ctx context.Context, channelID string) ([]db.Membership, error)
	// Deletes Team Invitations by Channel ID, returns db.ErrNoRowFoundForDeletion error if no Invitations found.
	DeleteChannelInvitations(ctx context.Context, userID string) error
	// Deletes Team Memberships by Channel ID, returns db.ErrNoRowFoundForDeletion error if no Memberships found.
	DeleteMemberships(ctx context.Context, channelID string) error
	// Deletes Featured By Channels by Channel ID, returns db.ErrNoRowFoundForDeletion error if no features found.
	DeleteAllFeaturedByChannel(ctx context.Context, channelID string) error
}

// PDMSClient reports a deletion to PDMS (https://wiki.twitch.com/display/SEC/PDMS-+Delete+pipeline+Service+Onboarding)
type PDMSClient interface {
	PromiseDeletion(context context.Context, userID string) error
}
