package httputil

import (
	"context"
	"net/http"
	"os"
	"os/signal"
	"syscall"
	"time"

	"code.justin.tv/amzn/TwitchTelemetryCircuitMetrics/circuitmetrics"
	poller "code.justin.tv/amzn/TwitchTelemetryPollingCollector"
	log "github.com/sirupsen/logrus"
)

const timeout = 5 * time.Second

// Graceful shuts down a server gracefully
func Graceful(ctx context.Context, server *http.Server, goStatsPoller *poller.PollingCollector, concurrencyMetrics *circuitmetrics.ConcurrencyCollector) {
	stop := make(chan os.Signal, 1)
	signal.Notify(stop, os.Interrupt, syscall.SIGTERM)

	<-stop

	ctx, cancel := context.WithTimeout(ctx, timeout)
	defer cancel()

	log.Infof("shutting down server with %s timeout", timeout)

	if err := server.Shutdown(ctx); err != nil {
		log.WithError(err).Fatal("server failed to shut down")
	} else {
		log.Info("gracefully shut down server")
	}

	goStatsPoller.Stop()
	if concurrencyMetrics != nil {
		if closeErr := concurrencyMetrics.Close(); closeErr != nil {
			log.WithError(closeErr).Fatal("concurrency metrics failed to shut down")
		}
	}
}
