package image

import "fmt"

const (
	legacyCDNPrefix             = "https://static-cdn.jtvnw.net/jtv_user_pictures/"
	legacyBackgroundKeyTemplate = "team-%s-background_image-%s.%s"
	legacyBannerKeyTemplate     = "team-%s-banner_image-%s-%s.%s"
	legacyLogoKeyTemplate       = "team-%s-team_logo_image-%s-%s.%s"

	legacyBannerResolution = "640x125"
	legacyLogoResolution   = "600x600"
)

// LegacyBackgroundURL returns the legacy URL of a team background image.
func LegacyBackgroundURL(teamName, id, format string) string {
	return legacyCDNPrefix + legacyBackgroundKey(teamName, id, format)
}

// LegacyBannerURL returns the legacy URL of a team banner image.
func LegacyBannerURL(teamName, id, format string) string {
	return legacyCDNPrefix + legacyBannerKey(teamName, id, format)
}

// LegacyLogoURL returns the legacy URL of a team logo image.
func LegacyLogoURL(teamName, id, format string) string {
	return legacyCDNPrefix + legacyLogoKey(teamName, id, format)
}

// LegacyKey maps an image's category to its filename or object key.
func LegacyKey(category, teamName, id, format string) string {
	switch category {
	case CategoryBackground:
		return legacyBackgroundKey(teamName, id, format)
	case CategoryBanner:
		return legacyBannerKey(teamName, id, format)
	case CategoryLogo:
		return legacyLogoKey(teamName, id, format)
	}
	return ""
}

func legacyBackgroundKey(teamName, id, format string) string {
	return fmt.Sprintf(legacyBackgroundKeyTemplate, teamName, id, format)
}

func legacyBannerKey(teamName, id, format string) string {
	return fmt.Sprintf(legacyBannerKeyTemplate, teamName, id, legacyBannerResolution, format)
}

func legacyLogoKey(teamName, id, format string) string {
	return fmt.Sprintf(legacyLogoKeyTemplate, teamName, id, legacyLogoResolution, format)
}
