package image

import (
	. "github.com/onsi/ginkgo"
	. "github.com/onsi/gomega"
)

var _ = Describe("Legacy", func() {
	var teamName = "name"
	var id = "id"
	var format = FormatPNG

	Describe("LegacyBackgroundURL", func() {
		It("returns a qualified url", func() {
			expected := "https://static-cdn.jtvnw.net/jtv_user_pictures/team-name-background_image-id.png"
			Expect(LegacyBackgroundURL(teamName, id, format)).To(Equal(expected))
		})
	})

	Describe("LegacyBannerURL", func() {
		It("returns a qualified url", func() {
			expected := "https://static-cdn.jtvnw.net/jtv_user_pictures/team-name-banner_image-id-640x125.png"
			Expect(LegacyBannerURL(teamName, id, format)).To(Equal(expected))
		})
	})

	Describe("LegacyLogoURL", func() {
		It("returns a qualified url", func() {
			expected := "https://static-cdn.jtvnw.net/jtv_user_pictures/team-name-team_logo_image-id-600x600.png"
			Expect(LegacyLogoURL(teamName, id, format)).To(Equal(expected))
		})
	})

	Describe("LegacyKey", func() {
		var category string

		Context("with an invalid category", func() {
			category = "not valid"
			It("returns empty string", func() {
				Expect(LegacyKey(category, teamName, id, format)).To(Equal(""))
			})
		})

		Context("with a valid category", func() {
			It("returns key for background", func() {
				category = CategoryBackground
				expected := "team-name-background_image-id.png"
				Expect(LegacyKey(category, teamName, id, format)).To(Equal(expected))
			})

			It("returns key for banner", func() {
				category = CategoryBanner
				expected := "team-name-banner_image-id-640x125.png"
				Expect(LegacyKey(category, teamName, id, format)).To(Equal(expected))
			})

			It("returns key for logo", func() {
				category = CategoryLogo
				expected := "team-name-team_logo_image-id-600x600.png"
				Expect(LegacyKey(category, teamName, id, format)).To(Equal(expected))
			})
		})
	})
})
