package image

import (
	"fmt"
	"strings"

	"github.com/satori/go.uuid"
)

// Maximum size of an image file:
const (
	kB      = 1000
	MaxSize = 500 * kB
)

// MaxIDLength is the maximum length of an image's ID.
const MaxIDLength = 32

// NewID generates an ID for an image.
func NewID() string {
	return strings.Replace(uuid.NewV4().String(), "-", "", -1)
}

// Accepted image categories:
const (
	CategoryBackground = "background"
	CategoryBanner     = "banner"
	CategoryLogo       = "logo"
)

// ValidCategory validates that the image category is one of the accepted categories.
func ValidCategory(category string) bool {
	return category == CategoryBackground || category == CategoryBanner || category == CategoryLogo
}

// Accepted image file types:
const (
	FormatJPEG = "jpeg"
	FormatPNG  = "png"
)

// ValidFormat validates that the image format is one of the accepted formats.
func ValidFormat(format string) bool {
	return format == FormatJPEG || format == FormatPNG
}

// Key returns the image object's storage key.
func Key(category, teamName, id, format string) string {
	return fmt.Sprintf("images/%s/%s/%s.%s", category, teamName, id, format)
}
