package image

import (
	"strings"

	. "github.com/onsi/ginkgo"
	. "github.com/onsi/gomega"
	"github.com/satori/go.uuid"
)

var _ = Describe("ValidCategory", func() {
	Context("with an invalid category", func() {
		category := "not valid"

		It("returns false", func() {
			Expect(ValidCategory(category)).To(BeFalse())
		})
	})

	Context("with a valid category", func() {
		category := CategoryBackground

		It("returns true", func() {
			Expect(ValidCategory(category)).To(BeTrue())
		})
	})
})

var _ = Describe("ValidFormat", func() {
	Context("with an invalid format", func() {
		format := "not valid"

		It("returns false", func() {
			Expect(ValidFormat(format)).To(BeFalse())
		})
	})

	Context("with a valid format", func() {
		format := FormatJPEG

		It("returns true", func() {
			Expect(ValidFormat(format)).To(BeTrue())
		})
	})
})

var _ = Describe("Key", func() {
	Context("with image params", func() {
		category := "category"
		teamName := "team-name"
		id := "id"
		format := "format"

		It("returns the object storage key of the image", func() {
			Expect(Key(category, teamName, id, format)).To(Equal("images/category/team-name/id.format"))
		})
	})
})

var _ = Describe("NewID", func() {
	It("returns a valid UUID without dashes", func() {
		id := NewID()

		u, err := uuid.FromString(id)
		Expect(err).NotTo(HaveOccurred())

		expected := strings.Replace(u.String(), "-", "", -1)
		Expect(id).To(Equal(expected))
	})
})
