package mapping

import (
	"fmt"
)

// Ordered is a map that keeps track of the order the keys were put in
type Ordered struct {
	keys []string
	m    map[string]interface{}
}

// NewOrdered returns a new Ordered map
func NewOrdered() Ordered {
	return Ordered{m: make(map[string]interface{})}
}

// Add adds a key to a Ordered map
func (o *Ordered) Add(key string, val interface{}) {
	o.keys = append(o.keys, key)
	o.m[key] = val
}

// Keys returns the list of keys that were added in order of addition
func (o *Ordered) Keys() []string {
	return o.keys
}

// ValuesByKeys converts keys to values in the order of keys
func (o *Ordered) ValuesByKeys(keys []string) ([]interface{}, error) {
	values := make([]interface{}, len(keys))
	for idx, key := range keys {
		value, ok := o.m[key]
		if !ok {
			return nil, fmt.Errorf("mapping: cannot convert keys to values: value not found for key %s", key)
		}
		values[idx] = value
	}
	return values, nil
}
