package name

import "regexp"

const (
	// MinLength is the minimum character count of a team's name.
	MinLength = 3

	// MaxLength is the maximum character count of a team's name.
	MaxLength = 25

	// MaxDisplayLength is the maximum character count of a team's DISPLAY name.
	//
	// As of February 13, 2018, the longest display name of all teams in
	// production is 63 characters, so we set this limit arbitrarily.
	MaxDisplayLength = 65
)

// Allow:
// 1. lowercase alphabetical or numeric first character
// 2. lowercase alphabetical, numeric, hyphen, or underscore in the middle
// 3. lowercase alphabetical or numeric last character
var validNameRegex = regexp.MustCompile(`^[a-z0-9]([a-z0-9_-]*[a-z0-9])?$`)

// Valid checks that a given name string contains only allowed characters.
func Valid(name string) bool {
	return validNameRegex.MatchString(name)
}
