package name

import (
	. "github.com/onsi/ginkgo"
	. "github.com/onsi/gomega"
)

var _ = Describe("Valid", func() {
	tests := []struct {
		Name     string
		Expected bool
	}{
		{"-leading-hyphen", false},
		{"trailing-hyphen-", false},
		{"_leading_underscore", false},
		{"trailing_underscore_", false},
		{"s p a c e s", false},
		{"UpPeRcAsE", false},
		{"$ymbo|$", false},
		{"*<>/[non-alphanumeric:,.]", false},
		{"valid", true},
		{"also-valid", true},
		{"valid_as_well", true},
	}

	It("returns true only if name is valid", func() {
		for _, test := range tests {
			Expect(Valid(test.Name)).To(Equal(test.Expected))
		}
	})
})
