package params

var truthys = map[string]struct{}{
	"true": {},
	"1":    {},
}

var falseys = map[string]struct{}{
	"false": {},
	"0":     {},
}

// QueryToBoolPointer converts an string query param representing a boolean to a boolean pointer
func QueryToBoolPointer(param string) *bool {
	if _, ok := truthys[param]; ok {
		truthy := true
		return &truthy
	}

	if _, ok := falseys[param]; ok {
		falsey := false
		return &falsey
	}

	return nil
}
