package s3

import (
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/s3"
)

// Client is a wrapper for the AWS S3 client.
type Client struct {
	service           Service
	sourceBucket      string
	destinationBucket string
}

// NewClient instantiates a Client.
func NewClient(awsSession *session.Session, source, destination string) *Client {
	return &Client{
		service:           s3.New(awsSession),
		sourceBucket:      source,
		destinationBucket: destination,
	}
}
