package uploader

import (
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/s3"
)

// Client is a wrapper for the AWS S3 client.
// Specifically, Client creates pre-signed upload URLs.
type Client struct {
	service Service
	bucket  string
}

// NewClient instantiates a Client.
func NewClient(awsSession *session.Session, bucket string) *Client {
	// As of February 23, 2018, using the AWS Go SDK to customize the endpoint
	// of an S3 client does not strip out the bucket name from the path
	// (https://github.com/aws/aws-sdk-go/issues/1777).
	//
	// Ideally, we would use a custom domain for the S3 bucket, via:
	//
	// s3CustomizedSession := awsSession.Copy(&aws.Config{
	// 	Endpoint: aws.String(bucket),
	// })
	//
	// Using the above AWS session results in the doubling of the bucket name,
	// e.g. https://my.custom.bucket.endpoint/my.custom.bucket.endpoint/...
	//
	// Using the custom domain would also require SSL, via CloudFront distribution.

	return &Client{
		service: s3.New(awsSession),
		bucket:  bucket,
	}
}
