package worker

import (
	"net/http"

	"code.justin.tv/cb/roster/internal/clients/telemetryhook"
	"code.justin.tv/cb/roster/internal/httputil"
	"goji.io"
	"goji.io/pat"
)

// Server contains a router and client interfaces to downstream services.
type Server struct {
	mux      *goji.Mux
	cache    Cache
	dbWriter DBWriter
}

// ServerParams contains the required params for creating a server.
type ServerParams struct {
	Cache            Cache
	DBWriter         DBWriter
	TelemetryHandler telemetryhook.Handler
}

// NewServer instantiates a Server with the defined routes and corresponding handlers,
// and returns the Server.
// client.go in the db package implements the DB interface.
func NewServer(params *ServerParams) *Server {
	server := &Server{
		mux:      goji.NewMux(),
		cache:    params.Cache,
		dbWriter: params.DBWriter,
	}

	server.mux.Use(httputil.PanicRecoveryMiddleware)
	server.mux.HandleFunc(pat.Get("/health"), httputil.HealthCheck)

	root := goji.SubMux()
	server.mux.Handle(pat.New("/*"), root)
	root.Use(httputil.AccessLogMiddleware)
	root.Use(params.TelemetryHandler.TelemetryMetricsHandler)

	root.HandleFunc(pat.Post("/process"), server.process)

	return server
}

// ServeHTTP allows Server to implement http.Handler.
func (s *Server) ServeHTTP(w http.ResponseWriter, req *http.Request) {
	s.mux.ServeHTTP(w, req)
}
