package worker

import (
	"context"

	"code.justin.tv/cb/roster/internal/db"
)

// Cache is the interface to a caching service.
type Cache interface {
	ClearChannelMemberships(ctx context.Context, id string) error
	ClearAllTeamMembershipsForTeam(ctx context.Context, id string) error
}

// DBWriter is how the Roster app expects the writing to DB to be.
type DBWriter interface {
	GetChannelMemberships(ctx context.Context, channelID string) ([]db.Membership, error)

	DeleteChannelInvitations(ctx context.Context, userID string) error

	DeleteMemberships(ctx context.Context, channelID string) error

	DeleteAllFeaturedByChannel(ctx context.Context, channelID string) error
}
