// BUILD
multiJob('cb-roster-build') {
  concurrentBuild()

  scm {
    git {
      remote {
        github 'cb/roster', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }

  triggers {
    githubPush {
      githubPolling(false)
    }
  }

  configure { project ->
    project / builders / 'com.cloudbees.jenkins.GitHubSetCommitStatusBuilder'
  }

  publishers {
    githubCommitNotifier()
  }

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    sshAgent 'git-aws-read-key'
    buildName('#\${BUILD_NUMBER} (\${GIT_BRANCH})')
  }

  steps {
    phase('Build') {
      phaseJob('cb-roster-build-api') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }
      phaseJob('cb-roster-build-worker') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }
    }
  }
}


freeStyleJob('cb-roster-build-api') {
  parameters {
    stringParam 'GIT_COMMIT'
  }

  concurrentBuild()

  scm {
    git {
      remote {
        github 'cb/roster', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }

  triggers {
    githubPush {
      githubPolling(false)
    }
  }

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    colorizeOutput()
    sshAgent 'git-aws-read-key'
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-config')
    }
    buildName('#\${BUILD_NUMBER} (\${GIT_BRANCH})')
  }

  steps {
    shell './scripts/build_api.sh'
  }
}

freeStyleJob('cb-roster-build-worker') {
  parameters {
    stringParam 'GIT_COMMIT'
  }

  concurrentBuild()

  scm {
    git {
      remote {
        github 'cb/roster', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }

  triggers {
    githubPush {
      githubPolling(false)
    }
  }

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    colorizeOutput()
    sshAgent 'git-aws-read-key'
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-config')
    }
    buildName('#\${BUILD_NUMBER} (\${GIT_BRANCH})')
  }

  steps {
    shell './scripts/build_worker.sh'
  }
}

// DEPLOY
multiJob('cb-roster-deploy') {
  parameters {
    stringParam 'ENVIRONMENT'
    stringParam 'BRANCH'
    stringParam 'GIT_COMMIT'
  }

  concurrentBuild()

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    buildName('#\${BUILD_NUMBER} - \${ENVIRONMENT}')
  }

  steps {
    phase('Deploy') {
      phaseJob('cb-roster-deploy-api') {
        killPhaseCondition('FAILURE')
      }
      phaseJob('cb-roster-deploy-worker') {
        killPhaseCondition('FAILURE')
      }
    }
  }
}

freeStyleJob('cb-roster-deploy-api') {
  using 'TEMPLATE-minimal-skadi-deploy'

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-config')
    }
    buildName('#\${BUILD_NUMBER} (\${BRANCH}) - \${ENVIRONMENT}')
  }

  scm {
    git {
      remote {
        github 'cb/roster', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      branches '${GIT_COMMIT}'
      clean true
    }
  }

  steps {
    shell './scripts/deploy_api.sh'
  }
}

freeStyleJob('cb-roster-deploy-worker') {
  using 'TEMPLATE-minimal-skadi-deploy'

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-config')
    }
    buildName('#\${BUILD_NUMBER} (\${BRANCH}) - \${ENVIRONMENT}')
  }

  scm {
    git {
      remote {
        github 'cb/roster', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      branches '${GIT_COMMIT}'
      clean true
    }
  }

  steps {
    shell './scripts/deploy_worker.sh'
  }
}
