SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET row_security = off;

SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;


CREATE TABLE teams (
  id integer NOT NULL,
  name character varying(255),
  display_name character varying(255),
  user_id integer,
  info text,
  banner_image character varying(255),
  created_at timestamp without time zone,
  updated_at timestamp without time zone,
  background_color character varying(255),
  background_image character varying(255),
  background_no_repeat boolean,
  team_logo_image character varying(255),
  short_name character varying(255),
  status character varying(255) DEFAULT 'active'::character varying,
  focus_info_tab boolean DEFAULT false NOT NULL,
  show_chat_tab boolean DEFAULT false
);


ALTER TABLE teams OWNER TO roster_01;


CREATE SEQUENCE teams_id_seq
  START WITH 1
  INCREMENT BY 1
  NO MINVALUE
  NO MAXVALUE
  CACHE 1;


ALTER TABLE teams_id_seq OWNER TO roster_01;
ALTER SEQUENCE teams_id_seq OWNED BY teams.id;

ALTER TABLE ONLY teams ALTER COLUMN id SET DEFAULT nextval('teams_id_seq'::regclass);

ALTER TABLE ONLY teams
  ADD CONSTRAINT teams_pkey PRIMARY KEY (id);


CREATE INDEX index_teams_on_name ON public.teams USING btree (name);


REVOKE ALL ON TABLE teams FROM PUBLIC;
REVOKE ALL ON TABLE teams FROM roster_01;
GRANT ALL ON TABLE teams TO roster_01;

REVOKE ALL ON SEQUENCE teams_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE teams_id_seq FROM roster_01;
GRANT ALL ON SEQUENCE teams_id_seq TO roster_01;
