SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET row_security = off;
SET search_path = public, pg_catalog;
SET default_tablespace = '';
SET default_with_oids = false;

CREATE TABLE team_streams (
    id integer NOT NULL,
    team_id integer,
    user_id integer,
    display_order integer DEFAULT 0,
    created_at timestamp without time zone,
    updated_at timestamp without time zone
);


ALTER TABLE team_streams OWNER TO roster_01;

CREATE SEQUENCE team_streams_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE team_streams_id_seq OWNER TO roster_01;
ALTER SEQUENCE team_streams_id_seq OWNED BY team_streams.id;
ALTER TABLE ONLY team_streams ALTER COLUMN id SET DEFAULT nextval('team_streams_id_seq'::regclass);

ALTER TABLE ONLY team_streams
    ADD CONSTRAINT team_streams_pkey PRIMARY KEY (id);

REVOKE ALL ON TABLE team_streams FROM PUBLIC;
REVOKE ALL ON TABLE team_streams FROM roster_01;
GRANT ALL ON TABLE team_streams TO roster_01;

REVOKE ALL ON SEQUENCE team_streams_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE team_streams_id_seq FROM roster_01;
GRANT ALL ON SEQUENCE team_streams_id_seq TO roster_01;