SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET row_security = off;
SET search_path = public, pg_catalog;
SET default_tablespace = '';
SET default_with_oids = false;

CREATE TABLE team_invitations (
    id integer NOT NULL,
    team_id integer,
    user_id integer,
    status character varying(255) DEFAULT 'pending'::character varying,
    created_on timestamp without time zone,
    updated_on timestamp without time zone
);


ALTER TABLE team_invitations OWNER TO roster_01;

CREATE SEQUENCE team_invitations_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE team_invitations_id_seq OWNER TO roster_01;

ALTER SEQUENCE team_invitations_id_seq OWNED BY team_invitations.id;

ALTER TABLE ONLY team_invitations ALTER COLUMN id SET DEFAULT nextval('team_invitations_id_seq'::regclass);
ALTER TABLE ONLY team_invitations
    ADD CONSTRAINT team_invitations_pkey PRIMARY KEY (id);


CREATE INDEX index_team_invitations_on_team_id ON public.team_invitations USING btree (team_id);
CREATE INDEX index_team_invitations_on_user_id ON public.team_invitations USING btree (user_id);

REVOKE ALL ON TABLE team_invitations FROM PUBLIC;
REVOKE ALL ON TABLE team_invitations FROM roster_01;
GRANT ALL ON TABLE team_invitations TO roster_01;


REVOKE ALL ON SEQUENCE team_invitations_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE team_invitations_id_seq FROM roster_01;
GRANT ALL ON SEQUENCE team_invitations_id_seq TO roster_01;

