#!/bin/bash
set -ex

CONFIG="config/$ENVIRONMENT.yaml"

rm -rf deploy
mkdir -p deploy

echo -e "\033[0;34mCopying application configurations from $CONFIG\033[0m"
cp $CONFIG deploy/config.yaml 2>/dev/null || echo -e "\033[0;31mFailed to copy application config YAML. Proceeding with deployment.\033[0m"

cp -R .ebextensions/ deploy/.ebextensions

cd deploy

cat <<EOF > Dockerrun.aws.json
{
  "AWSEBDockerrunVersion": "1",
  "Image": {
    "Name": "docker.pkgs.xarth.tv/cb/roster-worker:$GIT_COMMIT",
    "Update": "false"
  },
  "Ports": [
    {
      "ContainerPort": "8000"
    }
  ],
  "Volumes": [
    {
      "ContainerDirectory": "/var/app",
      "HostDirectory": "/var/app"
    }
  ],
  "Logging": "/var/log/"
}
EOF

mkdir -p .elasticbeanstalk

cat <<EOF > .elasticbeanstalk/config.yml
global:
  application_name: cb-roster-$ENVIRONMENT
  default_region: us-west-2
  profile: twitch-cb-aws
EOF

eb deploy cb-roster-$ENVIRONMENT-worker \
  --label $ENVIRONMENT-worker-$GIT_COMMIT \
  --message "$BRANCH" \
  --verbose
