#!/usr/bin/env bash

RECORD_COUNTS_STATEMENT=$(cat <<SQL
  SELECT 'teams', COUNT(1) FROM teams
  UNION SELECT 'team_invitations', COUNT(1) FROM team_invitations
  UNION SELECT 'team_streams', COUNT(1) FROM team_streams
  UNION SELECT 'team_users', COUNT(1) FROM team_users;
SQL
)

DELETE_STATEMENTS=$(cat <<SQL
  DELETE from teams;
  DELETE from team_invitations;
  DELETE from team_streams;
  DELETE from team_users;
SQL
)

echo $(date -u) "RosterDB: ${ROSTERDB_HOST}:${ROSTERDB_PORT}/${ROSTERDB_NAME}"
echo $(date -u) "SiteDB: ${SITEDB_HOST}:${SITEDB_PORT}/${SITEDB_NAME}"

echo "=========="
echo $(date -u) "RosterDB record counts:"
psql -h $ROSTERDB_HOST -p $ROSTERDB_PORT -U $ROSTERDB_USER -d $ROSTERDB_NAME -c "${RECORD_COUNTS_STATEMENT}"

echo "=========="
echo $(date -u) "Initial SiteDB record counts:"
psql -h $SITEDB_HOST -p $SITEDB_PORT -U $SITEDB_USER -d $SITEDB_NAME -c "${RECORD_COUNTS_STATEMENT}"

echo "=========="
echo $(date -u) "Migrating all team tables from RosterDB to SiteDB..."
psql -h $SITEDB_HOST -p $SITEDB_PORT -U $SITEDB_USER -d $SITEDB_NAME -c "${DELETE_STATEMENTS}"
pg_dump --table="^team*" --data-only --no-privileges --no-security-labels -O -h $ROSTERDB_HOST -p $ROSTERDB_PORT -U $ROSTERDB_USER -d $ROSTERDB_NAME | sed -e '/^--/d' | psql -h $SITEDB_HOST -p $SITEDB_PORT -U $SITEDB_USER -d $SITEDB_NAME

echo "=========="
echo $(date -u) "Final SiteDB record counts:"
psql -h $SITEDB_HOST -p $SITEDB_PORT -U $SITEDB_USER -d $SITEDB_NAME -c "${RECORD_COUNTS_STATEMENT}"
