#!/usr/bin/env bash
#Staging
#export SITEDB_HOST=replica-sitedb.staging.us-west2.justin.tv
#export SITEDB_PORT=11006
#export SITEDB_DATABASE=roster_justintv_dev
#export ROSTERDB_HOST=cb-roster-staging.cqyyxr1hxrhn.us-west-2.rds.amazonaws.com

#Production
export SITEDB_HOST=sitedb-replica-internal.prod.us-west2.justin.tv
export SITEDB_PORT=12006
export SITEDB_DATABASE=roster_justintv_prod
export ROSTERDB_HOST=cb-roster-production.cqyyxr1hxrhn.us-west-2.rds.amazonaws.com

echo "SiteDB: ${SITEDB_HOST}:${SITEDB_PORT} ${SITEDB_DATABASE}"
echo "RosterDB: ${ROSTERDB_HOST}"
echo

echo "SiteDB records"
psql -h $SITEDB_HOST -p $SITEDB_PORT -U roster_01 $SITEDB_DATABASE -c "SELECT 'teams',COUNT(1) FROM teams UNION SELECT 'team_invitations', COUNT(1) FROM team_invitations UNION SELECT 'team_users',COUNT(1) FROM team_users UNION SELECT 'team_streams',COUNT(1) FROM team_streams;"

echo "Migrating all tables"
psql -h $ROSTERDB_HOST -p 5432 -U roster_01 roster -c 'TRUNCATE teams;TRUNCATE team_invitations;TRUNCATE team_users;TRUNCATE team_streams;'
pg_dump --table="^team*" --data-only --no-privileges --no-security-labels -O -h $SITEDB_HOST -p $SITEDB_PORT -U roster_01 $SITEDB_DATABASE | sed -e '/^--/d' | psql -h $ROSTERDB_HOST -p 5432 -U roster_01 roster

echo "RosterDB records"
psql -h $ROSTERDB_HOST -p 5432 -U roster_01 roster -c "SELECT 'teams',COUNT(1) FROM teams UNION SELECT 'team_invitations', COUNT(1) FROM team_invitations UNION SELECT 'team_users',COUNT(1) FROM team_users UNION SELECT 'team_streams',COUNT(1) FROM team_streams;"
